# -*- coding: utf-8 -*-
import click


@click.command('create_reindex_task', help=u'Создать таск на переиндексацию для быстрого мува. По умолчанию создается со статусом CREATED,'
                    u' то есть не запустится.')
@click.option('-u', '--uid', help=u'Идентификаор пользователя', required=True)
@click.option('-s', '--status', type=click.Choice(['CREATED', 'READY']), default='CREATED',
              help=u'Статус таска:\n`CREATED` (default) просто создает таск в базе\n'
              u'`READY` создает таск в базе, который может быть запущен менеджером')
def create_reindex_task(uid, status):
    import mpfs.engine.process
    mpfs.engine.process.setup_admin_script()

    from mpfs.core.services.reindex.link_data_update_manager import create_task
    create_task(uid, status)


@click.command('set_reindex_task_status', help=u'Поменять статус созданному таску на переиндексацию.')
@click.option('-u', '--uid', help=u'Идентификаор пользователя', required=True)
@click.option('-s', '--status', type=click.Choice(['CREATED', 'READY']), required=True, help=u'Статус таска')
def set_reindex_task_status(uid, status):
    import mpfs.engine.process
    mpfs.engine.process.setup_admin_script()

    from mpfs.core.services.reindex.link_data_update_manager import set_migration_task_status
    set_migration_task_status(uid, status)


@click.command('start_link_data_update_manager', help=u'Точка входа для запуска менеджера, который запустит воркеры для апдейта link data.')
def start_link_data_update_manager():
    import mpfs.engine.process
    mpfs.engine.process.setup_admin_script()

    from mpfs.core.services.reindex.link_data_update_manager import BazingaLinkDataUpdateManager
    BazingaLinkDataUpdateManager().run()


@click.command('start_link_data_update_worker', help=u'Точка входа для запуска воркера для апдейта link data.')
@click.argument('uid', nargs=1)
def start_link_data_update_worker(uid):
    import mpfs.engine.process
    mpfs.engine.process.setup_admin_script()

    from mpfs.core.services.reindex.link_data_update_worker import BazingaLinkDataUpdateWorker
    BazingaLinkDataUpdateWorker(uid).run()


@click.command('start_reindex_manager', help=u'Точка входа для запуска менеджера, который запустит обновление индекса в поиске.')
def start_reindex_manager():
    import mpfs.engine.process
    mpfs.engine.process.setup_admin_script()

    from mpfs.core.services.reindex.reindex_manager import BazingaQuickMoveReindexManager
    BazingaQuickMoveReindexManager().run()


@click.command('start_reindex_worker', help=u'Точка входа для запуска воркера для вызова переиндексатора.')
@click.argument('uid', nargs=1)
def start_reindex_worker(uid):
    import mpfs.engine.process
    mpfs.engine.process.setup_admin_script()

    from mpfs.core.services.reindex.reindex_worker import BazingaReindexLaunchWorker
    BazingaReindexLaunchWorker(uid).run()
