# -*- coding: utf-8 -*-
import click


@click.command('zaberun_encode_stid')
@click.option("-s", "--stid", help=u"Строка `stid`", required=True)
@click.option("-q/-n", "--quote/--no-quote", help=u"Urlencode результата", default=True)
def zaberun_encode_stid(stid, quote):
    """
    Cкрипт-шифратор стида через Заберун
    """
    from mpfs.core.services.zaberun_service import Zaberun
    zaberun = Zaberun()
    processed_stid = zaberun.crypt_agent.encrypt(stid, urlsafe=True)

    if quote:
        import urllib
        processed_stid = urllib.quote(processed_stid, safe="")

    click.echo(processed_stid)
