# -*- coding: utf-8 -*-
import mpfs.engine.process
from mpfs.common.util import to_json
from mpfs.common import errors
from mpfs.core.services.common_service import Service

service_log = mpfs.engine.process.get_service_log("comments")


class CommentsService(Service):
    """
    Сервис для общения с API комментариев

    Документация по API: https://wiki.yandex-team.ru/disk/commentaries/backend-api/
    """
    name = 'comments'
    api_error = errors.CommentsBadResponse
    log = service_log
    base_url = None  # should be set in config
    timeout = None  # should be set in config

    def update_entity(self, uid, entity_type, entity_id, data=None):
        method = 'PATCH'
        path = '/v1/commentaries/%s/%s?__uid=%s' % (entity_type, entity_id, uid)
        headers = {
            'X-Yandex-Service': 'mpfs',
        }
        url = '%s%s' % (self.base_url, path)
        pure_data = None
        if data:
            pure_data = to_json(data)
        return self.open_url(url, method=method, pure_data=pure_data,
                             retry=True, return_status=True, headers=headers,
                             timeout=self.timeout)

    def enable_comments(self, uid, entity_type, entity_id):
        data = {"comments_disabled": False}
        self.update_entity(uid, entity_type, entity_id, data=data)

    def disable_comments(self, uid, entity_type, entity_id):
        data = {"comments_disabled": True}
        self.update_entity(uid, entity_type, entity_id, data=data)


comments = CommentsService()
