# -*- coding: utf-8 -*-
import mpfs.engine.process

from mpfs.config import settings
from mpfs.core.services.rate_limiter_service import RateLimiterService

service_log = mpfs.engine.process.get_service_log('dataapi-rate-limiter')


class DataApiRateLimiterService(RateLimiterService):
    name = 'dataapi_rate_limiter'
    log = service_log

    @property
    def enabled(self):
        return settings.feature_toggles['dataapi_rate_limiter']


dataapi_rate_limiter = DataApiRateLimiterService()
