# -*- coding: utf-8 -*-
"""
EmailSenderService (Рассылятор)

https://github.yandex-team.ru/sendr/sendr/blob/master/docs/transaction-api.md
https://st.yandex-team.ru/CHEMODAN-55721
"""
from mpfs.common.util import to_json
from mpfs.core.services.common_service import RequestsPoweredServiceBase


class EmailSenderService(RequestsPoweredServiceBase):

    relative_url_template = '/api/0/{account}/transactional/{campaign_id}/send'

    def __init__(self):
        self.account = None
        self.token = None
        self.async = True
        self.mail_account = None
        self.mail_token = None
        super(EmailSenderService, self).__init__()

    def send(self, email_address, campaign_id, template_args=None, async=None, use_mail_account=False):
        """
        Функция отправки письма через рассылятор

        :param email_address: адрес на который нужно отправить письмо
        :param campaign_id: идентификатор рассылки из рассылятора
        :param template_args: dict с параметрами для подстановки в шаблон
        :param async: флаг режима отправки, если не передан, то значение берется из конфига
        :return: инстанс requests.models.Response
        """
        params = {'to_email': email_address}
        data = {}

        if template_args:
            data['args'] = to_json(template_args)

        data['async'] = self.async if async is None else async

        account = self.account
        auth = (self.token, '')
        if use_mail_account:
            account = self.mail_account
            auth = (self.mail_token, '')

        relative_url = self.relative_url_template.format(account=account, campaign_id=campaign_id)
        return self.request('POST', relative_url, data=data, params=params, auth=auth)


email_sender = EmailSenderService()
