# -*- coding: utf-8 -*-
import mpfs.engine.process

from mpfs.common import errors
from mpfs.core.services.common_service import Service

service_log = mpfs.engine.process.get_service_log('event-history-api')


class EventHistorySearchService(Service):
    """
    Сервис для общения с Сервисом поиска по истории событий

    https://beta.wiki.yandex-team.ru/ps/documentation/ipdd/
    """
    name = 'event_history'
    api_error = errors.EventHistoryBadResponse
    log = service_log
    base_url = None  # should be set in config
    timeout = None  # should be set in config
    group_interval = None  # should be set in config

event_history_search_service = EventHistorySearchService()
