# -*- coding: utf-8 -*-
"""

MPFS
CORE

Сервис Геокодер

"""
import mpfs.engine.process

from mpfs.core.services.common_service import Service
from mpfs.common import errors
from mpfs.common.util import from_json

service_log = mpfs.engine.process.get_service_log('geocoder')


class Geocoder(Service):

    name = 'geocoder'
    api_error = errors.GeocoderNoResponse
    log = service_log

    def __init__(self, *args, **kwargs):
        super(Geocoder, self).__init__(*args, **kwargs)

    def get_place(self, position, lang='ru_RU'):
        url = self.base_url % (lang, position)
        try:
            response = self.open_url(url)
        except Exception:
            result = {}
        else:
            members = from_json(response)['response']['GeoObjectCollection']['featureMember']
            geo_object = members[0]['GeoObject']['metaDataProperty']['GeocoderMetaData']['AddressDetails']
            result = {
                'address': geo_object['Country']['AddressLine'],
                'country': geo_object['Country']['CountryName'],
                'area': geo_object['Country']['AdministrativeArea']['AdministrativeAreaName'],
            }
            if 'SubAdministrativeArea' in geo_object['Country']['AdministrativeArea']:
                result['locality'] = geo_object['Country']['AdministrativeArea']['SubAdministrativeArea']['Locality']['LocalityName']
            elif 'Locality' in geo_object['Country']['AdministrativeArea']:
                if 'LocalityName' in geo_object['Country']['AdministrativeArea']['Locality']:
                    result['locality'] = geo_object['Country']['AdministrativeArea']['Locality']['LocalityName']
                elif 'Premise' in geo_object['Country']['AdministrativeArea']['Locality']:
                    result['locality'] = geo_object['Country']['AdministrativeArea']['Locality']['Premise']['PremiseName']
        finally:
            return result