# -*- coding: utf-8 -*-
"""

MPFS
CORE

Сервис скрытых файлов хранилища
Service for hidden files on storage
Araçlar gizli dosyaları saklama
工具隱藏文件存儲

"""
import time

from mpfs.config import settings
from mpfs.core.metastorage.control import hidden_data
from mpfs.core.services.disk_service import MPFSStorageService, Resources

FEATURE_TOGGLES_SETTING_YAROVAYA_MARK_ENABLED = settings.feature_toggles['setting_yarovaya_mark_enabled']


class Hidden(MPFSStorageService):

    name = 'hidden'
    control = hidden_data

    def __init__(self, *args, **kwargs):
        MPFSStorageService.__init__(self, *args, **kwargs)
        from mpfs.core.filesystem.resources.hidden import HiddenFile, HiddenFolder
        self.resources = Resources(dir=HiddenFolder, file=HiddenFile)

    def make_folder(self, address, parent, data={}):
        value = {'dtime': int(time.time()),}
        if FEATURE_TOGGLES_SETTING_YAROVAYA_MARK_ENABLED and data.get('meta', {}).get('yarovaya_mark'):
            value['yarovaya_mark'] = True
        return self.control.make_folder(address.uid, address.path, value)
