# -*- coding: utf-8 -*-

from __future__ import unicode_literals

import urlparse

import mpfs.engine.process
import mpfs.common.errors as errors
from mpfs.common.static.tags import POST
from mpfs.common.util import from_json
from mpfs.common.util import urls


from mpfs.core.services.common_service import Service

service_log = mpfs.engine.process.get_service_log('lenta_loader')


class LentaLoaderService(Service):
    name = 'lenta_loader'
    api_error = errors.LentaLoaderNoResponse
    log = service_log

    def delete_empty_block(self, qs):
        """
        Отправить нотификацию о наличии пустого блока в ленте пользователя.

        :param qs: строка с GET-параметрами, при передаче которой в ручку `lenta_block_list`
                   был получен пустой ответ.
        :return:
        """
        api_method = 'api/delete-empty-block'
        pr = list(urlparse.urlparse(urlparse.urljoin(self.base_url, api_method)))
        pr[4] = qs
        url = urlparse.urlunparse(pr)
        status_code, content, headers = self.open_url(url, return_status=True)
        return status_code, content, headers

    def delete_block(self, uid, block_id):
        """
        Удалить блок из ленты пользователя (без всяких проверок).
        """
        api_method = 'api/delete-block'
        url = urlparse.urljoin(self.base_url, api_method)
        self.open_url(
            '%s?uid=%s&block_id=%s' % (url, uid, block_id),
        )

    def save_file_from_public(self, fs_copy_event_log_message):
        """Создать блок content_block для файла, сохраняемого из паблика.

        Возвращает идентификатор блока или None в случае ошибки.
        Можно дергать даже с евентом о сохранении папки и ничего не сломается у Ленты.
        """
        api_method = 'api/save_file_from_public'
        url = urlparse.urljoin(self.base_url, api_method)
        try:
            status_code, content, headers = self.open_url(
                url=url,
                method=POST,
                pure_data=fs_copy_event_log_message,
                headers={b'Content-Type': b'text/plain'},  # Warning! Нужна строка!
                return_status=True
            )
            if status_code == 200:
                return from_json(content).get('block_id')
        except self.api_error:
            pass

    def start_saving_folder_from_public(self, uid, resource_id, resource_path):
        """Создать блок folder_creation для папки, сохраняемой из паблика."""
        api_method = 'api/start_saving_folder_from_public'
        url = urlparse.urljoin(self.base_url, api_method)
        data = {
            'uid': uid,
            'folderId': resource_id,
            'folderPath': resource_path,
        }
        try:
            status_code, content, headers = self.open_url(
                url=url,
                method=POST,
                pure_data=urls.urlencode(data),
                return_status=True
            )
            if status_code == 200:
                return from_json(content).get('block_id')
        except self.api_error:
            pass

    def process_log_line_and_return_created_block_id(self, event_history_log_message):
        api_method = 'api/process_log_line_and_return_created_block_id'
        url = urlparse.urljoin(self.base_url, api_method)
        try:
            status_code, content, headers = self.open_url(
                url=url,
                method=POST,
                pure_data=event_history_log_message,
                headers={b'Content-Type': b'text/plain'},  # Warning! Нужна строка!
                return_status=True
            )
            if status_code == 200:
                return from_json(content).get('block_id')
        except self.api_error:
            pass

lenta_loader = LentaLoaderService()
