# -*- coding: utf-8 -*-
"""

MPFS
CORE

Сервис для работы с logreader
https://wiki.yandex-team.ru/disk/log-reader/counters

"""
import traceback
import urllib

import mpfs.engine.process

from mpfs.config import settings
from mpfs.common.util import from_json
from mpfs.core.services.common_service import Service
from mpfs.common.static.tags import POST

error_log = mpfs.engine.process.get_error_log()
service_log = mpfs.engine.process.get_service_log('logreader')


class LogreaderService(Service):

    name = 'logreader'
    log = service_log

    def get_one_counter(self, public_hash):
        result = 0
        if not settings.feature_toggles['logreader']:
            return result
        """
        Получить счётчик для одного хэша
        Принимает хэш, возвращает значение счётчика
        """

        data = {
            'hashes': public_hash,
        }
        try:
            response = self.open_url(self.base_url, post=data)
            result = from_json(response).get(public_hash, 0)
        except Exception:
            error_log.error(traceback.format_exc())

        return result

    def get_counters(self, public_hashes):
        """
        Получить счётчики для нескольких хэшей
        Принимает список хэшей, возвращает dict {hash: counter_value}
        """
        result = {}
        if not settings.feature_toggles['logreader']:
            return result

        data = {
            'hashes': ','.join(public_hashes),
        }
        try:
            result = from_json(self.open_url(self.base_url, post=data))
        except Exception:
            error_log.error(traceback.format_exc())

        return result

    def reset_counter(self, public_hash):
        if not settings.feature_toggles['logreader']:
            return
        if public_hash:
            url = self.base_url + '/reset?hash=%s' % urllib.quote(public_hash)
            try:
                self.open_url(url, method=POST)
            except Exception:
                error_log.error(traceback.format_exc())

