# -*- coding: utf-8 -*-
"""

MPFS
CORE

Сервис хранения чего угодно 

"""

from mpfs.core.metastorage.control import misc
from mpfs.core.services.disk_service import StorageSpaceUnlimited, Resources


class Misc(StorageSpaceUnlimited):

    name = 'misc'
    control = misc

    def __init__(self, *args, **kwargs):
        super(Misc, self).__init__(*args, **kwargs)
        from mpfs.core.filesystem.resources.misc import MiscFile, MiscFolder
        self.resources = Resources(dir=MiscFolder, file=MiscFile)

    def free(self, uid):
        return 107374182400 

    def make_folder(self, address, parent, data={}):
        from mpfs.core.user import base
        if int(base.NeedInit(address.uid, type='settings')):
            base.Create(address.uid, type='settings')
        
        return super(Misc, self).make_folder(address, parent, data)
