# -*- coding: utf-8 -*-

"""
Сторадж заметок (храним информацию по файлам, приложенным к заметкам, не сами заметки).
Никакие события с файлами и папками этого стораджа не пишутся в эвент лог
(сделано это для того, чтобы они не попадали в Ленту).
В фотосрез ресурсы не попадают.
Данные в индекс не шлются.
Размер хранилища - анлим.

https://st.yandex-team.ru/CHEMODAN-38605
"""

from mpfs.core.metastorage.control import notes
from mpfs.core.services.disk_service import StorageSpaceUnlimited, Resources


class NotesStorageService(StorageSpaceUnlimited):
    name = 'notes_storage'
    control = notes

    def __init__(self, *args, **kwargs):
        super(NotesStorageService, self).__init__(*args, **kwargs)
        from mpfs.core.filesystem.resources.notes import NotesFile, NotesFolder
        self.resources = Resources(dir=NotesFolder, file=NotesFile)

    def free(self, uid):
        return 107374182400

    def used(self, uid):
        size = self.control.sum('data.size', match={'uid': str(uid)})
        return size
