# -*- coding: utf-8 -*-

import urlparse

import mpfs.engine.process
from mpfs.common import errors
from mpfs.common.static.tags import GET, POST
from mpfs.common.util import to_json
from mpfs.common.util.urls import urlencode

from mpfs.core.services.common_service import Service

SERVICE_NAME = 'notifier'

service_log = mpfs.engine.process.get_service_log(SERVICE_NAME)


class NotifierService(Service):
    """
    Сервис нотификаций.

    https://wiki.yandex-team.ru/disk/projects/notification-system/
    https://wiki.yandex-team.ru/disk/projects/notification-system/razrabotka/
    """
    name = SERVICE_NAME
    api_error = errors.NotifierBadResponse
    log = service_log
    base_url = None  # should be set in config
    timeout = None  # should be set in config

    NOTIFICATION_GROUPS = ('comments', 'likes', 'autoupload')

    def add_notification(self, uid, service, actor, _type, meta):
        url = urlparse.urljoin(self.base_url, 'add-notification')
        query = urlencode({
            'uid': uid,
            'service': service,
            'actor': actor,
            'type': _type,
        })
        url += ('?' + query)
        # параметр любой может быть как в теле, так в GET-параметрах
        try:
            self.open_url(url, method=POST, pure_data=urlencode({'meta': to_json(meta)}))
        except self.api_error:
            return False
        else:
            return True

    def send_upgrade_notification(self, uid, os, device_id):
        url = urlparse.urljoin(self.base_url, 'send-upgrade-notification')
        sending_device_id = 'device_id.%s' % device_id
        sending_device_id = sending_device_id.lower().replace('-', '')
        query = urlencode({
            'uid': uid,
            'os': os,
            'deviceId': sending_device_id,
        })
        url += ('?' + query)
        try:
            self.open_url(url, method=POST)
        except self.api_error:
            return False
        else:
            return True

notifier = NotifierService()
