import jwt

from mpfs.common.util import to_json
from mpfs.config import settings
from mpfs.core.services.common_service import RequestsPoweredServiceBase


class OnlyOfficeBalancerService(RequestsPoweredServiceBase):
    def drop_session(self, users, key, host):
        OFFICE_ONLY_OFFICE_INBOX_SECRET = settings.office['only_office']['inbox_secret']
        config = {"c": "drop", "users": users,
                  "key": key}
        encoded_config = jwt.encode(config, OFFICE_ONLY_OFFICE_INBOX_SECRET)
        base_url = self.base_url % host
        return self.request('POST', '/coauthoring/CommandService.ashx', data=to_json({'token': encoded_config}),
                            base_url=base_url, headers={'Content-type': 'application/json'})

    def info(self, key, host):
        OFFICE_ONLY_OFFICE_INBOX_SECRET = settings.office['only_office']['inbox_secret']
        config = {"c": "info", "key": key}
        encoded_config = jwt.encode(config, OFFICE_ONLY_OFFICE_INBOX_SECRET)
        base_url = self.base_url % host
        return self.request('POST', '/coauthoring/CommandService.ashx', data=to_json({'token': encoded_config}),
                            base_url=base_url, headers={'Content-type': 'application/json'})


only_office_balancer_service = OnlyOfficeBalancerService()
