from mpfs.common.errors import OrchestratorNotFoundError, OrchestratorError, OrchestratorSessionInactiveError
from mpfs.core.services.common_service import RequestsPoweredServiceBase


class OrchestratorService(RequestsPoweredServiceBase):

    def __init__(self):
        self.create_session_timeout = None
        super(OrchestratorService, self).__init__()

    def create_session(self, session_id, group_id):
        return self.request('PUT', '/v1/session/%s' % session_id, {'group_id': group_id},
                            timeout=self.create_session_timeout).json()

    def get_session(self, session_id):
        return self.request('GET', '/v1/session/%s' % session_id).json()

    def delete_session(self, session_id):
        return self.request('DELETE', '/v1/session/%s' % session_id)

    def refresh_session(self, session_id):
        return self.request('POST', '/v1/session/%s' % session_id)

    def get_sessions(self):
        return self.request('GET', '/v1/session/').json()

    def _exception_from_response(self, response):
        code = response.status_code
        if code == 404:
            return OrchestratorNotFoundError()
        elif code == 409:
            return OrchestratorSessionInactiveError()
        return OrchestratorError()


orchestrator_service = OrchestratorService()
