# -*- coding: utf-8 -*-
from mpfs.core.metastorage.control import photounlim
from mpfs.core.services.disk_service import MPFSStorageService, Resources
from mpfs.core.user.constants import PHOTOUNLIM_AREA


class Photounlim(MPFSStorageService):

    name = PHOTOUNLIM_AREA
    control = photounlim

    def __init__(self, *args, **kwargs):
        super(Photounlim, self).__init__(*args, **kwargs)
        from mpfs.core.filesystem.resources.photounlim import PhotounlimFile, PhotounlimFolder
        self.resources = Resources(dir=PhotounlimFolder, file=PhotounlimFile)

    def free(self, uid):
        return 107374182400

    def used(self, uid):
        size = self.control.sum('data.size', match={'uid': str(uid)})
        return size
