# -*- coding: utf-8 -*-
"""
Сервис поиска для платформы. Проблема в том, что в search_service есть импорт из filesystem, поэтому оно не
стартует в платформе. Но мы хотим ходить в поиск в одну ручку из платформы, поэтому такой сервис нужен

"""

import socket
import urllib2
import urllib

import mpfs.engine.process
import mpfs.common.errors as errors

from mpfs.engine.http import client
from mpfs.core.services.common_service import Service

service_log = mpfs.engine.process.get_service_log("search")
error_log = mpfs.engine.process.get_error_log()


class PlatformDiskSearch(Service):

    name = 'search_disk'
    api_error = errors.SearchError
    log = service_log

    def warmup_cache(self, uid):
        """
        Прогрев поискового кэша по пользователю. Запросы не ретраим, ответа не ждем, ошибки поиска игнорируем.

        :param uid: uid пользователя
        :return: None
        """
        encoded_params = urllib.urlencode({'uid': uid})
        url = '%s/warmup?%s' % (self.host, encoded_params)
        try:
            client.open_url(url, self.log, timeout=self.warmup_timeout, retry=False, rais=True, api_err=None)
        except socket.timeout:
            pass
        except urllib2.HTTPError:
            # "Не удалось прогреть — значит не удалось" - (с) Дмитрий Потапов
            pass


platform_disk_search = PlatformDiskSearch()
