# -*- coding: utf-8 -*-
import mpfs.engine.process

from mpfs.common import errors
from mpfs.core.services.common_service import Service

service_log = mpfs.engine.process.get_service_log('profile')


class ProfileService(Service):
    """
    Сервис для общения с API профилей

    Документация по API: https://wiki.yandex-team.ru/users/arhibot/profile
    """
    name = 'profile'
    api_error = errors.ProfileBadResponse
    log = service_log
    base_url = None  # should be set in config
    timeout = None  # should be set in config

profile = ProfileService()
