# -*- coding: utf-8 -*-
"""

MPFS
CORE

Сервис API Телемоста

"""

import mpfs.common.errors as errors
import mpfs.engine.process
from mpfs.common.util import from_json
from mpfs.core.services.common_service import RequestsPoweredServiceBase

service_log = mpfs.engine.process.get_service_log('ps-billing')


class PsBillingService(RequestsPoweredServiceBase):

    def __init__(self):
        super(PsBillingService, self).__init__()
        self.send_cloud_request_id = True

    def _exception_from_response(self, response):
        status_code = response.status_code
        json = from_json(response.content)
        code = status_code
        if isinstance(json, dict):
            code = json.get('error', {}).get('name', str(status_code))
        if status_code == 404:
            return errors.PsBillingNotFound(code)
        if status_code == 403:
            return errors.PsBillingForbidden(code)
        if status_code == 400:
            return errors.PsBillingBadRequest(code)
        if status_code == 410:
            return errors.PsBillingGone(code)
        if status_code == 409:
            return errors.PsBillingConflict(code)
        return errors.PsBillingBadResponse(status_code, response)

    def activate_promo(self, promo_key, uid, activate_if_used=False, send_email=False):
        return self.request('POST', '/v1/promo/%s/activate' % promo_key,
                            {'activateIfUsed': activate_if_used, 'sendEmail': send_email, '__uid': uid}).json()


ps_billing = PsBillingService()
