# -*- coding: utf-8 -*-
from mpfs.core.social.share import ShareProcessor
from mpfs.dao.session import Session
from mpfs.metastorage.postgres.queries import SQL_GET_FIDS_BY_PARENT_FID_FOR_USER, SQL_GET_ROOT_FID, SQL_FOLDER_BY_PATH


def calculate_max_folder_depth_for_path(uid, path):
    session = Session.create_from_uid(uid)
    cur = session.execute(SQL_GET_FIDS_BY_PARENT_FID_FOR_USER, {'uid': uid})

    parents_map = {}
    for row in cur:
        parent_fid = row['parent_fid']
        child_fids = row['children']
        parents_map[parent_fid.hex] = [i.hex for i in child_fids]

    session = Session.create_from_uid(uid)
    if path == '/':
        root_fid = session.execute(SQL_GET_ROOT_FID, {'uid': uid}).fetchone()[0].hex
    else:
        root_fid = session.execute(SQL_FOLDER_BY_PATH, {'uid': uid, 'path': path}).fetchone()['fid']

    current_level_fids = [root_fid]
    next_level_fids = []
    level = 0

    while len(current_level_fids):
        while len(current_level_fids):
            node_fid = current_level_fids.pop()
            if node_fid not in parents_map:
                continue  # no children for that parent
            next_level_fids.extend(parents_map[node_fid])

        if next_level_fids:
            level += 1

        current_level_fids = next_level_fids
        next_level_fids = []

    return level


def calculate_max_folder_depth(uid, include_shared_folders=True):
    max_level = calculate_max_folder_depth_for_path(uid, '/')

    if include_shared_folders:
        joined_folders = ShareProcessor().list_joined_folders(uid)
        for folder in joined_folders:
            owner_uid = folder.link.group.owner
            owner_path = folder.link.group.path
            participant_path = folder.link.path
            shared_folder_max_depth = calculate_max_folder_depth_for_path(owner_uid, owner_path)
            shared_folder_level = participant_path.count('/')

            if max_level < shared_folder_level + shared_folder_max_depth:
                max_level = shared_folder_level + shared_folder_max_depth

    return max_level
