# -*- coding: utf-8 -*-
import datetime
from urllib2 import HTTPError

from mpfs.common.util import to_json, from_json
from mpfs.core.services.common_service import RequestsPoweredServiceBase


class RestoreDBService(RequestsPoweredServiceBase):
    """Класс для работы с датасинком через апи персонализации для восстановления файлов"""
    FILE_RESTORE_DB_PATH = '/v1/personality/profile/yadisk/restore_db'
    PUBLIC_UID = 'public'

    def put_personal(self, uid, checksums_obj):
        req_path = "%s/%s" % (self.FILE_RESTORE_DB_PATH, checksums_obj.hid)
        data = to_json({
            'md5': checksums_obj.md5,
            'size': checksums_obj.size,
            'sha256': checksums_obj.sha256,
            'date_created': datetime.datetime.now().isoformat()
        })
        self.request('PUT', req_path, headers={'X-Uid': uid}, data=data)

    def put_public(self, checksums_obj):
        return self.put_personal(self.PUBLIC_UID, checksums_obj)

    def delete_personal(self, uid, hid):
        req_path = "%s/%s" % (self.FILE_RESTORE_DB_PATH, hid)
        try:
            self.request('DELETE', req_path, headers={'X-Uid': uid})
        except HTTPError as e:
            if e.code != 404:
                raise

    def delete_public(self, hid):
        return self.delete_personal(self.PUBLIC_UID, hid)

    def get_personal(self, uid, hid):
        req_path = "%s/%s" % (self.FILE_RESTORE_DB_PATH, hid)
        try:
            response = self.request('GET', req_path, headers={'X-Uid': uid})
        except HTTPError as e:
            if e.code != 404:
                raise
            return None
        else:
            return from_json(response.content)

    def get_public(self, hid):
        return self.get_personal(self.PUBLIC_UID, hid)

    def is_personal_exists(self, uid, hid):
        if self.get_personal(uid, hid) is not None:
            return True
        return False

    def is_public_exists(self, hid):
        return self.is_personal_exists(self.PUBLIC_UID, hid)

    def is_exists(self, uid, hid):
        return self.is_public_exists(hid) or self.is_personal_exists(uid, hid)


restore_db_service = RestoreDBService()
