# -*- coding: utf-8 -*-
import urlparse
from urllib import urlencode

import mpfs.engine.process

from mpfs.common import errors
from mpfs.core.services.common_service import Service

service_log = mpfs.engine.process.get_service_log('smartcache')


class SmartcacheService(Service):
    """
    Сервис для общения с smartcache

    Документация: https://wiki.yandex-team.ru/disk/photoslice-smartcache
    """
    name = 'smartcache'
    api_error = errors.DataApiBadResponse
    log = service_log
    base_url = None  # should be set in config
    worker_url = None  # should be set in config
    initialize_photostream_url = None  # should be set in config
    timeout = None  # should be set in config

    def notify_worker(self, uid, timestamps=None):
        """Обновить снепшот.

        :param timestamps: Опциональные значение ctime, mtime, etime и utime для ускорения фотосреза

        :type uid: str
        :type timestamps: dict or None.
        :rtype: None
        """
        url = self.build_worker_url(uid, timestamps)
        self.open_url(url)

    def initialize_photostream(self, uid):
        params = {'__uid': uid, 'async': True}
        url = self.common_build_url(self.initialize_photostream_url, params)
        self.open_url(url)

    def build_worker_url(self, uid, timestamps=None, operation=None, action=None):
        """Вернуть URL для обновления SmartCache.

        Пример взят отсюда:
        https://st.yandex-team.ru/CHEMODAN-23380
        """

        params = {
            # Используется только в индексаторе, для простоты добавляем всегда
            'deduplication-key': 'smartcache-notify-%s' % uid,
            '__uid': uid
        }
        if timestamps:
            for k, v in timestamps.iteritems():
                params[k] = v

        if operation:
            params['operation'] = operation
        if action:
            params['action'] = action

        return self.common_build_url(self.worker_url, params)

    def common_build_url(self, url, params):
        query = urlencode(params)

        url_parts = list(urlparse.urlparse(url))
        url_parts[4] = query

        return urlparse.urlunparse(url_parts)


smartcache = SmartcacheService()
