# -*- coding: utf-8 -*-
from lxml import etree

import mpfs.engine.process

from mpfs.core.services.common_service import RequestsPoweredServiceBase


log = mpfs.engine.process.get_default_log()

class SpamCheckResolution(object):
    def __init__(self, raw_so_response):
        # Possible response formats:
        # <spam>1</spam>
        # <spam receipt="base64_str">0</spam>
        self._raw_so_response = raw_so_response
        etree_element = etree.fromstring(raw_so_response)

        self.is_spam = str(etree_element.text).lower() in ('1', 'true')
        self.receipt = etree_element.attrib.get('receipt')

    def has_receipt(self):
        return bool(self.receipt)

    def __repr__(self):
        return "%s(%s)" % (self.__class__.__name__, self._raw_so_response)


class SpamCheckerService(RequestsPoweredServiceBase):
    def check(self, uid, name, login, recipient, message, ip):
        params = {
            'so_ip': ip,
            'so_host': 'yadi.sk',
            'so_realpath': 'disk_share_folder',
            'so_form_name': 'disk_share_folder',
            'so_service': 'DISK',
            'so_uid': mpfs.engine.process.get_cloud_req_id(),  # уникальный идентификатор запроса
            'so_nick': name,  # имя отправителя
            'so_login': login,  # логин отправителя
            'so_userid': uid,  # uid отправителя
            'so_comment': message,  # тело письма
            'so_rcpt': recipient,  # обычно сколько получателей, для приглашений в ОП сказали передавать почту получателя
        }
        response = self.request('GET', '/check', params)
        raw_so_response = response.content.strip()
        log.info('spam check for uid=%s name=%s login=%s recipient=%s message=%s ip=%s returned %s, result is %s' % (uid, name, login, recipient, message, ip, response.content, raw_so_response))
        return SpamCheckResolution(raw_so_response)


spam_checker = SpamCheckerService()
