# -*- coding: utf-8 -*-
import json
import urllib

from mpfs.common.util import to_json
from mpfs.core.services.common_service import Service


class StartrekService(Service):
    name = 'startrek'
    token = None
    create_comment_url = None

    def open_url(self, url, post={}, cookie={}, **kwargs):
        headers = {'Authorization': 'OAuth %s' % self.token, 'Content-Type': 'application/json;charset=UTF-8'}
        return super(StartrekService, self).open_url(self.base_url + url, post, cookie, headers=headers, **kwargs)

    def create_comment(self, issue, text):
        self.open_url(
            self.create_comment_url % urllib.quote_plus(issue),
            method='POST',
            pure_data=to_json({'text': text})
        )


startrek_service = StartrekService()
