# -*- coding: utf-8 -*-
"""

MPFS
CORE

Сервис шарилки

"""
from itertools import izip, repeat

import mpfs.engine.process
import mpfs.common.errors as errors

from mpfs.core.metastorage.control import (disk, operations, 
                                           disk_info, trash, 
                                           hidden_data, link_data)
from mpfs.core.services.disk_service import MPFSStorageService, Resources
from mpfs.core.address import Address

log = mpfs.engine.process.get_default_log()

REQUIRED_CONTENT_FOLDERS = (
    '/share',
)

PREDEFINED_CONTENT_FOLDERS = (
    '/share/dist',
    '/share/doc',
    '/share/music',
    '/share/video',
    '/share/img',
)

REQUIRED_FOLDERS = \
    list(izip(REQUIRED_CONTENT_FOLDERS, repeat(disk, len(REQUIRED_CONTENT_FOLDERS))))


REQUIRED_DOMAINS = (
    disk,
    disk_info,
    trash,
    hidden_data,
    link_data,
)

SHARE_UID = mpfs.engine.process.share_user()


def _setup():
    
    import mpfs.core.filesystem.base
    fs = mpfs.core.filesystem.base.Filesystem()
    
    try:
        need_init = not mpfs.engine.process.usrctl().check(SHARE_UID)
    except errors.StorageInitUser, e:
        need_init = True
                
    if need_init:
        log.debug('creating repository for %s' % SHARE_UID)
        mpfs.engine.process.usrctl().create(SHARE_UID)

    for contr in REQUIRED_DOMAINS:
        if not contr.check(SHARE_UID):
            contr.create(SHARE_UID)
            log.debug('created %s domain for %s' % (contr.name, SHARE_UID))

    for path, storage in REQUIRED_FOLDERS:
        response = storage.show(SHARE_UID, path)
        if response.value is None:
            log.debug('creating folder %s:%s' % (SHARE_UID, path))
            storage.make_folder(SHARE_UID, path, {})

    for folder in PREDEFINED_CONTENT_FOLDERS:
        try:
            address = Address.Make(SHARE_UID, folder)
            resource = fs.info(SHARE_UID, address.id)
        except errors.ResourceNotFound:
            log.debug('creating folder %s' % address.id)
            fs.mkdir(SHARE_UID, address.id)
        else:
            pass


class Stock(MPFSStorageService):
    name = 'share'
    control = disk

    def __init__(self, *args, **kwargs):
        MPFSStorageService.__init__(self, *args, **kwargs)
        from mpfs.core.filesystem.resources.stock import StockFile, StockFolder
        self.resources = Resources(dir=StockFolder, file=StockFile)

    def get_resource(self, uid, address, version=None, **kwargs):
        address.change_uid(SHARE_UID)
        return super(Stock, self).get_resource(uid, address, version, **kwargs)

    def url(self, uid, mid, name, **kwargs):
        kwargs['parser'] = 'share'
        return super(Stock, self).url(uid, mid, name, **kwargs)
