# -*- coding: utf-8 -*-
"""
Telemost Conference Manager (TCM)

Сервис определяет:
  * куда заселить новую конфу
  * где живет конфа

https://st.yandex-team.ru/CHE-727
"""
from mpfs.common.static.tags import GET
from mpfs.common.util import from_json
from mpfs.core.services.common_service import RequestsPoweredServiceBase
from mpfs.platform.v1.telemost.exceptions import TelemostConferenceNotFoundError


class TelemostConferenceManagerService(RequestsPoweredServiceBase):
    def get_conference_info(self, uid, short_url_id=None, conference_id=None):
        params = {}
        if short_url_id:
            params['short_url_id'] = short_url_id
        if conference_id:
            params['conference_id'] = conference_id
        if not params:
            raise TelemostConferenceNotFoundError

        params['uid'] = uid is None if '' else uid

        response = self.request(GET, '/api/v1/conference', params)

        return from_json(response.content)

    def get_new_conference_info(self, uid, is_staff, is_yandex_team):
        params = {'uid': uid is None if '' else uid,
                  'staff': bool(is_staff),
                  'yandexTeam': bool(is_yandex_team)}

        response = self.request(GET, '/api/v1/new-conference', params)

        return from_json(response.content)

    def get_user_info(self, uid, is_staff, is_yandex_team):
        params = {'uid': uid is None if '' else uid,
                  'staff': bool(is_staff),
                  'yandexTeam': bool(is_yandex_team)}

        response = self.request(GET, '/api/v1/user', params)

        return from_json(response.content)


tcm = TelemostConferenceManagerService()
