# -*- coding: utf-8 -*-
"""

MPFS
CORE

Сервис tikaite, выдает содержимое файла, подлежащее индексации

"""
import urllib

import mpfs.engine.process

import mpfs.common.errors as errors
from mpfs.common.util import from_json
from mpfs.core.services.common_service import Service
from mpfs.config import settings

error_log = mpfs.engine.process.get_error_log()
service_log = mpfs.engine.process.get_service_log('indexer')


class Tikaite(Service):

    name = 'tikaite'
    log = service_log

    def get_body(self, mid, mimetype):
        result = {}

        # обрабатываем некорректные mimetype
        try:
            mimetype = urllib.quote(mimetype)
        except Exception:
            mimetype = self.default_content_type

        try:
            response = self.open_url(self.base_url % (mid, self.port, mid, mimetype, settings.tikaite['body_text_limit']))
        except errors.APIError, e:
            code = int(e.data.get('code'))
            if code != 415:
                result = {
                    'tikaite_error': "%s %s" % (
                        e.data.get('code'),
                        e.data.get('text').decode('utf-8'),
                    )
                }
        else:
            try:
                result = from_json(response)
            except Exception as e:
                error_log.error(e)
                error_log.error("Tikaite, can't parse response")
                result = {'tikaite_error': "invalid json"}
        return result

    def log_response(self, *args):
        pass
