# -*- coding: utf-8 -*-

"""
Сервис для обращение к TVM демону - хостед сервису работы с тикетами

https://wiki.yandex-team.ru/passport/tvm2/tvm-daemon/
"""
import os

from mpfs.common.util import from_json
from mpfs.core.services.common_service import RequestsPoweredServiceBase
from mpfs.core.services.tvm_2_0_service import TVM2Ticket


class TVMDaemonService(RequestsPoweredServiceBase):

    local_auth_token = None
    auth_ticket_env = None
    src = None

    def __init__(self):
        super(TVMDaemonService, self).__init__()
        self.local_auth_token = os.getenv(self.auth_ticket_env, '')

    def get_service_ticket_for_client(self, dst_client_id):
        response = self.request(
            'GET', 'tickets',
            params={
                'src': self.src,
                'dsts': dst_client_id,
            },
            headers={'Authorization': self.local_auth_token}
        )
        return TVM2Ticket.build_tvm_ticket(from_json(response.content).values()[0]['ticket'])
