# -*- coding: utf-8 -*-
"""

MPFS
CORE

Сервис для стриминга видео

"""
import time
import urllib
import urlparse

import mpfs.engine.process

from mpfs.common import errors
from mpfs.common.util import to_json, from_json
from mpfs.common.util.urls import urlencode
from mpfs.core.services.common_service import Service
from mpfs.common.util.crypt_keyczar import CryptAgentKeyczar

service_log = mpfs.engine.process.get_service_log('video')


class VideoStreaming(Service):
    """Видеостриминг"""
    name = 'video_streaming'

    def get_video_info(self, owner_uid, stid, use_http=False, user_ip=None, client_id=None):
        """Получить ссылки для стриминга файла для непублчиных ручек"""
        return self._get_video_info(
            owner_uid, stid,
            use_http=use_http,
            user_ip=user_ip,
            is_public=False,
            client_id=client_id
        )

    def get_public_video_info(self, owner_uid, stid, use_http=False, user_ip=None, consumer_uid=None, client_id=None):
        """Получить ссылки для стриминга файла для публичных ручек"""
        return self._get_video_info(
            owner_uid, stid,
            use_http=use_http,
            user_ip=user_ip,
            consumer_uid=consumer_uid,
            is_public=True,
            client_id=client_id
        )

    def _get_video_info(self, owner_uid, stid, use_http=False, user_ip=None, consumer_uid=None, is_public=True, client_id=None):
        params = {
            'owner_uid': owner_uid,
            'public': is_public,
            'source': stid,
            'use_http': use_http,
        }
        if user_ip:
            params['user_ip'] = user_ip
        if consumer_uid:
            params['consumer_uid'] = consumer_uid
        if client_id:
            params['client_id'] = client_id
        url = '%s/info?%s' % (self.base_url, urlencode(params))

        try:
            result = self.open_url(url)
        except self.api_error, e:
            if e.data.get('code') == 422:
                raise errors.VideoStreamingUnprocessableEntity()
            else:
                raise
        else:
            return from_json(result)


class Video(Service):
    """Старый видеостриминг"""
    name = 'video'
    log = service_log

    def generate_url(self, consumer_uid, owner_uid, stid, hid, public=False, video_info=None, consumer_yandexuid=None):
        '''
        Генерация урла
        '''
        crypt_agent = CryptAgentKeyczar()
        params = {
            'stid': stid,
            'hid': hid,
            'owner-uid': owner_uid,
            'consumer-uid': consumer_uid,
            'timestamp': int(time.time()),
            'public': public,
        }

        if consumer_yandexuid:
            params['yandexuid'] = consumer_yandexuid

        stream_short = crypt_agent.encrypt(urllib.urlencode(params))

        if video_info:
            params['info'] = to_json(video_info)

        stream = crypt_agent.encrypt(urllib.urlencode(params))

        result = {
            'host': 'https://' + urlparse.urlparse(self.base_url).hostname,
            'stream': stream,
            'stream_short': stream_short,
        }

        return result

video = Video()
