# -*- coding: utf-8 -*-
import mpfs.engine.process

from mpfs.core.services.common_service import Service
from mpfs.common.errors import XivaError

service_log = mpfs.engine.process.get_service_log('xiva')


class XivaService(Service):
    """
    Сервис для работы с API Xiva.
    https://wiki.yandex-team.ru/yxiva/api/v2/
    """
    name = 'xiva'
    api_error = XivaError
    log = service_log
    base_url = None  # should be set in config
    timeout = None  # should be set in config
    service = None # should be set in config
    service_token = None  # should be set in config

    def open_url(self, url, post={}, cookie={}, **kwargs):
        status, message, headers = super(XivaService, self).open_url(url, post, cookie, **kwargs)
        return status, {'message': message}, headers

xiva_service = XivaService()
