# -*- coding: utf-8 -*-
import mpfs.engine.process

from mpfs.config import settings
from mpfs.core.services.rate_limiter_service import RateLimiterService

service_log = mpfs.engine.process.get_service_log('yarl-rate-limiter')


class YarlRateLimiterService(RateLimiterService):
    name = 'yarl_rate_limiter'
    log = service_log

    def __init__(self, prefix=None):
        super(YarlRateLimiterService, self).__init__()
        self.prefix = prefix

    @property
    def dry_run(self):
        return settings.feature_toggles['yarl_rate_limiter_dry_run']

    @property
    def enabled(self):
        return settings.feature_toggles['yarl_rate_limiter']

    def raw_is_limit_exceeded(self, group, counter_key, value):
        if self.prefix:
            counter_key = self.prefix + '_' + counter_key

        return self.request('GET', counter_key, params={'weight': value})


yarl_rate_limiter = YarlRateLimiterService()
yarl_dataapi_rate_limiter = YarlRateLimiterService('dataapi')
