# -*- coding: utf-8 -*-
from mpfs.core.metastorage.decorators import user_exists_and_not_blocked
from mpfs.core.snapshot.logic.snapshot import snapshot, indexer_snapshot
from mpfs.core.snapshot.logic import deltas as deltas_logic


@user_exists_and_not_blocked
def deltas(req):
    """Получить изменения от заданой ревизии

    Query string аргументы:
        * uid [обязательный]
        * base_revision [обязательный]
    """
    return deltas_logic.deltas(req.uid, req.base_revision, req.allow_quick_move_deltas)
