# -*- coding: utf-8 -*-
"""

MPFS
Social

Предоставляет механизмы социального взаимодействия пользователей

"""
import traceback
from mpfs.common.static.tags import PROVIDER, CONNECTION_ID, TYPE

import mpfs.engine.process
from mpfs.core.services.socialproxy_service import SocialProxy
from mpfs.common import errors

log = mpfs.engine.process.get_default_log()
error_log = mpfs.engine.process.get_error_log()

socialproxy = SocialProxy()


def user_rights(uid, scenario='invite'):
    '''
    Выдача информации о социальных правах юзера для указанного сценария:
    - invite (рассылку приглашений) (по-умолчанию)
    - photos_import (импорт фотографий)
    - photos_export (экспорт фотографий)
    '''
    return socialproxy.user_rights(uid, scenario)


def list_contacts(uid, show_groups):
    '''
    Постановка задачи на получение списка контактов
    '''
    from mpfs.core.operations import manager
    return manager.create_operation(uid, 'social', 'list_contacts', {'show_groups': show_groups})


def send_message(uid, provider, userid, template, params):
    '''
    Постановка задачи на высылку сообщения
    '''
    from mpfs.core.operations import manager
    return manager.create_operation(
        uid, 'social', 'send_message',
        odata=dict( 
            provider = provider,
            userid   = userid,
            template = template,
            params   = params,
        )
    )


def export_photos(uid, provider, albumid, photos):
    '''
    Экспортирует список фото в социальную сеть
    '''
    from mpfs.core.operations import manager
    return manager.create_operation(
        uid, 'social', 'export_photos',
        odata=dict(
            provider = provider,
            albumid = albumid,
            photos = photos,
        )
    )


def get_albums(uid, provider):
    '''
    Выдает список фотоальбомов пользователя для соц. сети provider
    '''
    from mpfs.core.user.base import User
    return socialproxy.get_albums(uid, provider, User(uid).locale)

def create_album(uid, provider, title, privacy):
    '''
    Создает альбом в соц. сети provider
    '''
    return socialproxy.create_album(uid, provider, title, privacy)

def import_photos(uid, provider, type, connection_id):
    '''
    Импорт фото из соцсети
    '''
    odata = {
        PROVIDER: provider,
        CONNECTION_ID: connection_id,
        TYPE: type,
    }
    from mpfs.core.operations import manager
    return manager.create_operation(uid, 'social', 'import_photos', odata)

def user_photos(uid, provider):
    '''
    Фото, на которых отмечен пользователь
    '''
    return socialproxy.user_photos(uid, provider)
