# -*- coding: utf-8 -*-
from mpfs.dao.base import (
    BaseDAO,
    BaseDAOItem,
)
from mpfs.dao.fields import (
    DateTimeField,
    IntegerField,
    StringField,
    UidField,
    UuidField,
)

from mpfs.metastorage.postgres.schema import group_invites


class GroupInvitesDAOItem(BaseDAOItem):
    mongo_collection_name = 'group_invites'
    postgres_table_obj = group_invites
    is_sharded = False

    @classmethod
    def get_postgres_primary_key(cls):
        return 'id'

    id = UuidField(mongo_path='_id', pg_path=group_invites.c.id)
    gid = UuidField(mongo_path='gid', pg_path=group_invites.c.gid)
    uid = UidField(mongo_path='uid', pg_path=group_invites.c.uid, default_value=None)
    name = StringField(mongo_path='name', pg_path=group_invites.c.name, default_value=None)
    version = IntegerField(mongo_path='v', pg_path=group_invites.c.version, default_value=None)
    rights = IntegerField(mongo_path='rights', pg_path=group_invites.c.rights)
    universe_login = StringField(mongo_path='universe_login', pg_path=group_invites.c.universe_login, default_value=None)
    universe_service = StringField(mongo_path='universe_service', pg_path=group_invites.c.universe_service, default_value=None)
    avatar = StringField(mongo_path='avatar', pg_path=group_invites.c.avatar, default_value=None)
    status = StringField(mongo_path='status', pg_path=group_invites.c.status, default_value=None)
    date_created = DateTimeField(mongo_path='ctime', pg_path=group_invites.c.date_created)


class GroupInvitesDAO(BaseDAO):
    dao_item_cls = GroupInvitesDAOItem
