# -*- coding: utf-8 -*-
from mpfs.dao.base import (
    BaseDAO,
    BaseDAOItem,
)
from mpfs.dao.fields import (
    DateTimeField,
    IntegerField,
    StringField,
    UidField,
    UuidField,
)

from mpfs.metastorage.postgres.schema import group_links


class GroupLinksDAOItem(BaseDAOItem):
    mongo_collection_name = 'group_links'
    postgres_table_obj = group_links
    is_sharded = False

    @classmethod
    def get_postgres_primary_key(cls):
        return 'id'

    id = UuidField(mongo_path='_id', pg_path=group_links.c.id)
    gid = UuidField(mongo_path='gid', pg_path=group_links.c.gid)
    uid = UidField(mongo_path='uid', pg_path=group_links.c.uid, default_value=None)
    path = StringField(mongo_path='path', pg_path=group_links.c.path, default_value=None)
    version = IntegerField(mongo_path='v', pg_path=group_links.c.version, default_value=None)
    rights = IntegerField(mongo_path='rights', pg_path=group_links.c.rights)
    b2b_key = StringField(mongo_path='b2b_key', pg_path=group_links.c.b2b_key, default_value=None)
    universe_login = StringField(mongo_path='universe_login', pg_path=group_links.c.universe_login, default_value=None)
    universe_service = StringField(mongo_path='universe_service', pg_path=group_links.c.universe_service, default_value=None)
    date_created = DateTimeField(mongo_path='ctime', pg_path=group_links.c.date_created)


class GroupLinksDAO(BaseDAO):
    dao_item_cls = GroupLinksDAOItem
