# -*- coding: utf-8 -*-
import uuid

from mpfs.dao.base import (
    BaseDAO,
    BaseDAOItem, PostgresBaseDAOImplementation,
)
from mpfs.dao.fields import (
    StringField,
    IntegerField,
    UidField,
    UuidField,
)

from mpfs.metastorage.postgres.schema import groups


class GroupsDAOItem(BaseDAOItem):
    mongo_collection_name = 'groups'
    postgres_table_obj = groups
    is_sharded = False

    @classmethod
    def get_postgres_primary_key(cls):
        return 'id'

    id = UuidField(mongo_path='_id', pg_path=groups.c.id)
    owner = UidField(mongo_path='owner', pg_path=groups.c.owner)
    path = StringField(mongo_path='path', pg_path=groups.c.path, default_value=None)
    size = IntegerField(mongo_path='size', pg_path=groups.c.size, default_value=0)
    version = IntegerField(mongo_path='v', pg_path=groups.c.version, default_value=None)


class GroupsDAO(BaseDAO):
    dao_item_cls = GroupsDAOItem

    def __init__(self):
        super(GroupsDAO, self).__init__()
        self._pg_impl = PostgresGroupsDAOImplementation(self.dao_item_cls)


class PostgresGroupsDAOImplementation(PostgresBaseDAOImplementation):
    def find_one(self, spec=None, fields=None, **kwargs):
        if '_id' in spec:
            # Валидируем gid
            try:
                uuid.UUID(hex=spec['_id'])
            except ValueError:
                return
        return super(PostgresGroupsDAOImplementation, self).find_one(spec, fields, **kwargs)
