# -*- coding: utf-8 -*-


import traceback


import mpfs.engine.process

from mpfs.common.util import name_from_path, Cached
from mpfs.core.metastorage.control import disk_info
from mpfs.core.user.constants import HAS_SHARED_FOLDERS_KEY

log = mpfs.engine.process.get_default_log()


class SharedEntity(Cached):

    __all__ = ()
    __dba__ = ('_id', 'v')
    controller = None
    _instances = {'id' : {}, 'uid_path' : {}}
    _shared_cache = {'has_shared': {}}
    u"""Общий кэш для наследников.
    Правила работы:
      1. Не переопределять его у наследников
      2. Измнения приосходят по доступу SharedEntity._shared_cache
         (т.к. изменять может понадобится не только в этом классе)
      3. reset любого наследника сбросит общий кэш (если нужно будет этого избегать - реализовать через параметр)
    """
    _loaded = {}

    def __init__(self, *args, **kwargs):
        for k,v in kwargs.iteritems():
            setattr(self, k, v)

    def save(self):
        value = {}
        for k in self.__all__:
            try:
                value[k] = getattr(self, k)
            except AttributeError:
                pass
        for k in self.__dba__:
            try:
                value[k] = getattr(self, k)
            except Exception:
                pass
        self.controller.put(value)

    def remove(self):
        self.controller.remove(**dict((k, getattr(self, k)) for k in self.__dba__))

    @property
    def folder_name(self):
        return name_from_path(self.path)

    @classmethod
    def reset(cls):
        cls._instances = {'id' : {}, 'uid_path' : {}}
        cls._loaded = {}
        SharedEntity._shared_cache = {'has_shared': {}}

    def rename(self, new_path):
        self.path = new_path
        self.save()

    @classmethod
    def has_shared(cls, uid):
        if uid not in cls._shared_cache['has_shared']:
            has_shared_folders = disk_info.find_one_by_field(uid, {'key': HAS_SHARED_FOLDERS_KEY})
            if has_shared_folders is not None:
                has_shared_folders = has_shared_folders['data']
            has_shared_folders = bool(has_shared_folders)
            cls._shared_cache['has_shared'][uid] = has_shared_folders

        return cls._shared_cache['has_shared'][uid]

    @classmethod
    def set_has_shared(cls, uid, value):
        cls._shared_cache['has_shared'][uid] = value
