# -*- coding: utf-8 -*-
from mpfs.core.user.base import User
from mpfs.core.event_dispatcher.events import subscribe
from mpfs.core.social.share.events import ShareActivateInviteEvent
from mpfs.core.services.directory_service import DirectoryService

directory_service = DirectoryService()


@subscribe(ShareActivateInviteEvent)
def notify_directory(event):
    """Уведомляем Директорию"""
    user = event.data['user']
    link = event.data['link']
    if user.is_b2b():
        owner_user = User(link.group.owner)
        if owner_user.is_b2b() and user.b2b_key == owner_user.b2b_key:
            directory_service.notify_user_activate_invite(
                owner_user.uid,
                link.group.gid,
                user.uid,
                read_only=not link.is_rw()
            )
