# -*- coding: utf-8 -*-
from mpfs.core.event_dispatcher.events import Event
from mpfs.core.social.share.group import Group
from mpfs.core.social.share.link import LinkToGroup
from mpfs.core.social.share.invite import GroupInvites
from mpfs.core.user.common import CommonUser


class ShareEvent(Event):
    """Базовое событие по работе с общими папками"""
    required_fields = (('uid', basestring),)


class ShareGroupEvent(ShareEvent):
    """Базовый класс событий, связанных непосредственно с общей папкой"""
    required_fields = (('group', Group),)


class ShareLinkToGroupEvent(ShareEvent):
    """Базовый класс событий, связанных со ссылкой на общую папку"""
    required_fields = (('link', LinkToGroup),)


class ShareGroupInvitesEvent(ShareEvent):
    """Базовый класс событий по работе с инвайтами"""
    required_fields = (('invite', GroupInvites),)


# owner events

class ShareOwnerEvent(object):
    """Базовый класс событий владельца общей папки"""


class ShareCreateGroupEvent(ShareGroupEvent, ShareOwnerEvent):
    """Событие создания общей папки"""


class ShareUnshareFolderEvent(ShareGroupEvent, ShareOwnerEvent):
    """Событие удаления общей папки"""


class ShareCreateInviteEvent(ShareGroupInvitesEvent, ShareOwnerEvent):
    """Событие создания приглашения к общей папке"""


class ShareRemoveInviteEvent(ShareGroupInvitesEvent, ShareOwnerEvent):
    """Событие удаления приглашения к общей папке"""


class ShareChangeInviteRightsEvent(ShareGroupInvitesEvent, ShareOwnerEvent):
    """Событие изменения прав доступа к общей папке для инвайта"""
    required_fields = (('prev_rights', object),)


class ShareChangeGroupOwnerEvent(ShareLinkToGroupEvent, ShareOwnerEvent):
    """Событие изменения владельца общей папки"""
    required_fields = (('new_link', LinkToGroup),)


class ShareChangeRightsEvent(ShareLinkToGroupEvent, ShareOwnerEvent):
    """Событие изменения прав доступа к общей папке для пользователя"""
    required_fields = (('prev_rights', object),)


class ShareKickFromGroupEvent(ShareLinkToGroupEvent, ShareOwnerEvent):
    """Событие удаления доступа пользователя к общему каталогу"""


# invitee events

class ShareUserEvent(object):
    """Базовый класс событий пользователя (не владельца)"""


class ShareActivateInviteEvent(ShareLinkToGroupEvent, ShareUserEvent):
    """Событие активации приглашения"""
    required_fields = (
        ('invite', GroupInvites),
        ('user', CommonUser),
    )


class ShareRejectInviteEvent(ShareGroupInvitesEvent, ShareUserEvent):
    """Событие отклонения приглашения"""


class ShareLeaveGroupEvent(ShareLinkToGroupEvent, ShareUserEvent):
    """Событие отписки от общего каталога"""
