# -*- coding: utf-8 -*-
from mpfs.core.operations.base import Operation
from mpfs.core.user.base import User
from mpfs.core.social.share.group import Group
from mpfs.core.social.share.processor import ShareProcessor
from mpfs.common.util import hashed


class ShareB2bSynchronizeAccessOperation(Operation):
    type = 'share'
    subtype = 'b2b_synchronize_access'

    @classmethod
    def Create(cls, uid, odata, **kwargs):
        group = Group.load(gid=odata['gid'])
        user = User(uid)
        ShareProcessor.check_synchronization_with_b2b_allowed(user, group)

        oid = odata['id']
        odata['deduplicated'] = False

        operation = super(ShareB2bSynchronizeAccessOperation, cls).Create(uid, odata, **kwargs)

        # такой корявый способ определить, что операция уже была в БД
        if oid != operation.id:
            operation.data['deduplicated'] = True
            operation.save()
        return operation

    def get_uniq_id(self):
        return hashed("%s:%s" % (self.uid, self.data['gid']))

    def call_callback(self):
        # циклический импорт
        from mpfs.core.operations import manager
        successfully_finished = self.is_completed() or self.is_done()
        if successfully_finished and self.data['deduplicated']:
            # за время обработки операции был ещё запрос на пересинхронизацию
            # ставим новую таску
            manager.create_operation(self.uid, self.type, self.subtype, {'gid': self.data['gid']})

    def _process(self):
        user = User(self.uid)
        group = Group.load(gid=self.data['gid'])
        ShareProcessor().synchronize_with_b2b(user, group)
        self.set_completed()
