# -*- coding: utf-8 -*-
"""

MPFS
SUPPORT
Код работы с комментариями саппортилки


"""
import time
import base64

import mpfs.engine.process

from mpfs.core.metastorage.control import support
from mpfs.metastorage.mongo.util import id_for_key
from mpfs.common.util import normalize_string

log = mpfs.engine.process.get_default_log()
error_log = mpfs.engine.process.get_error_log()


def select(uid):
    '''
    Выборка комментариев по пользователю
    '''
    return support.folder_content(uid, None)


def find_by_id(file_id):
    '''
    Поиск заблокированного файла по _id
    '''
    result = support.folder_content(None, key={'id': file_id})
    return result


def find_by_hash(hsh):
    '''
    Поиск заблокированного файла по хэшу
    '''
    hsh = base64.b64encode(base64.b64decode(normalize_string(hsh)))
    result = support.folder_content(None, key={'hash': hsh})
    if result and isinstance(result, list):
        return result.pop()
    else:
        return result


def create(uid, moderator, comment_type, data):
    '''
    Сохранение комментария в базе
    '''
    ctime = int(time.time())

    _data = {
        'ctime': ctime,
        'moderator': moderator,
        'type': comment_type,
    }

    _data.update(data)

    support.put(str(uid), _data)


def update(uid, spec, data):

    support.update(uid, {'id': id_for_key(spec['address'])}, data)
