# -*- coding: utf-8 -*-
from mpfs.dao.base import (
    BaseDAO,
    BaseDAOItem,
)
from mpfs.dao.fields import (
    DateTimeField,
    StringField,
    UidField,
    UuidField,
)

from mpfs.metastorage.postgres.schema import support_block_history


class SupportBlockHistoryDAOItem(BaseDAOItem):
    mongo_collection_name = 'support_block_history'
    postgres_table_obj = support_block_history
    is_sharded = False

    @classmethod
    def get_postgres_primary_key(cls):
        return 'id'

    id = UuidField(mongo_path='_id', pg_path=support_block_history.c.id)
    ctime = DateTimeField(mongo_path='ctime', pg_path=support_block_history.c.ctime, default_value=None)
    hids = StringField(mongo_path='hids', pg_path=support_block_history.c.hids, default_value=None)
    moderator = StringField(mongo_path='moderator', pg_path=support_block_history.c.moderator)
    public_hashes = StringField(mongo_path='public_hashes', pg_path=support_block_history.c.public_hashes, default_value=None)
    type = StringField(mongo_path='type', pg_path=support_block_history.c.type, default_value=None)
    uids = StringField(mongo_path='uids', pg_path=support_block_history.c.uids, default_value=None)


class SupportBlockHistoryDAO(BaseDAO):
    dao_item_cls = SupportBlockHistoryDAOItem
