# -*- coding: utf-8 -*-
"""

MPFS
SUPPORT

Исключения

"""
from mpfs.common.static import codes as common_codes
from mpfs.common.static import messages as common_messages
from mpfs.common.errors import MPFSRootException

class SupportError(MPFSRootException):
    response = common_messages.default_response

    def __init__(self, *args, **kwargs):
        super(SupportError, self).__init__(*args, **kwargs)
        self.message = self.message + self.extra_msg

codes = (
    USER_NOT_SUBSCRIBED,
    BLOCKING_ERROR,
    UNBLOCKING_ERROR,
    INVALID_STARTREK_ISSUE
) = xrange(4)

class InvalidStartrekIssue(SupportError):
    code = INVALID_STARTREK_ISSUE
    message = 'startrek issue is invalid'
    response = 400

class UserNotSubscribed(SupportError):
    code = USER_NOT_SUBSCRIBED
    message = 'user not subscibed'
    response = 409

class BlockingError(SupportError):
    code = BLOCKING_ERROR
    message = 'error, user not blocked'
    response = 500

class UnblockingError(SupportError):
    code = UNBLOCKING_ERROR
    message = 'error unblocking user'
    response = 500
