# -*- coding: utf-8 -*-
"""

MPFS
SUPPORT
Код работы с очередью модерации


"""
import time
import datetime

import mpfs.engine.process
from mpfs.core.metastorage.control import support_moderation_queue

log = mpfs.engine.process.get_default_log()
error_log = mpfs.engine.process.get_error_log()


def select(*args):
    '''
    Выборка комментариев по пользователю
    '''
    return support_moderation_queue.moderation_queue(*args)


def set_status(_id, moderator, status):
    '''
    Поставить статус
    '''
    ctime = int(time.time())
    return support_moderation_queue.set_status(_id, moderator, ctime, status)


def count(status=None, created=None):
    '''
    Получить количество элементов
    '''
    spec = {}
    if status:
        spec['status'] = status
    if created:
        spec['created'] = {'$gt': datetime.datetime.fromtimestamp(float(created))}
    return support_moderation_queue.moderation_queue_count(spec)
