# -*- coding: utf-8 -*-
"""

MPFS
USER
Код работы с пользователем


"""
import mpfs.engine.process
import comment

from mpfs.core.support import errors
from mpfs.core.user.base import User


log = mpfs.engine.process.get_default_log()
error_log = mpfs.engine.process.get_error_log()

usrctl = mpfs.engine.process.usrctl()


def block(uid, moderator, text):
    '''
    Блокировка пользователя
    '''
    User(uid).set_block(1)
    blocked = False
    try:
        userinfo = usrctl.check(uid)
        blocked = bool(int(userinfo['blocked']))
    except Exception:
        raise errors.BlockingError
    else:
        if blocked:
            data = {
                'comment': text,
                'address': 'account',
            }
            comment.create(uid, moderator, 'block_user', data)
            return True
        else:
            raise errors.BlockingError


def unblock(uid, moderator, text):
    '''
    Разблокировка пользователя
    '''
    User(uid).set_block(0)
    
    userinfo = usrctl.check(uid)
    blocked = bool(int(userinfo.get('blocked', 0)))
    if not blocked:
        data = {
            'comment': text,
            'address': 'account',
        }
        comment.create(uid, moderator, 'unblock_user', data)
        return True
    else:
        raise errors.UnblockingError
