# -*- coding: utf-8 -*-
"""
Анонимный пользователь

Без Диска.
Используется для доступа к фичам с анонимным доступом.
"""
from mpfs.core.user.constants import DEFAULT_LOCALE


class AnonymousUID(object):
    PREFIX = 'yandexuid:'

    @staticmethod
    def to_anonymous_uid(uid):
        return '%s%s' % (AnonymousUID.PREFIX, uid)

    @staticmethod
    def is_anonymous_uid(uid):
        if not isinstance(uid, basestring):
            return False
        return uid.startswith(AnonymousUID.PREFIX)


class AnonymousUser(object):
    def __init__(self, uid):
        self.uid = uid
        self.b2b_key = ''

    def get_supported_locale(self):
        return DEFAULT_LOCALE

    def is_yateam(self):
        return False

    def is_paid(self):
        return False

    def get_office_selection_strategy(self):
        return None

    def get_user_info(self):
        return {'username': u'Anonymous',
                'uid': self.uid,
                'display_name': u'Anonymous'}

    def has_shared_folders(self):
        return False

    def get_default_product_id(self):
        return None
