# -*- coding: utf-8 -*-
"""

MPFS
CORE

Пользователь Почты: грузит аттачи

"""
import traceback

from itertools import izip, repeat

import mpfs.engine.process

from mpfs.core.metastorage.control import attach, link_data
from mpfs.core.user.constants import *
from mpfs.core.user.base import CommonUser

log = mpfs.engine.process.get_default_log()
error_log = mpfs.engine.process.get_error_log()

usrctl = mpfs.engine.process.usrctl()
dbctl = mpfs.engine.process.dbctl()

ATTACH_REQUIRED_USER_DOMAINS =(
    attach,
    link_data,
)

ATTACH_REQUIRED_FOLDERS = list(izip(('/attach',), repeat(attach, 1)))


class AttachUser(CommonUser):
    
    required_user_domains = ATTACH_REQUIRED_USER_DOMAINS
    required_folders = ATTACH_REQUIRED_FOLDERS
    required_files = []
    predefined_content_folders = {}
    predefined_content_files = {}
    subscribe_passport = False
    type = 'attach'
        
    @classmethod
    def Create(cls, uid, **params):
        try:
            locale = DEFAULT_LOCALE
            cls._create_user_in_db(uid, locale)
            cls._create_domains(uid)
            cls._create_system_folders(uid)
        except Exception:
            log.warning('user creation failed, rollbacking %s' % uid)
            error_log.error(traceback.format_exc())
            raise

    @classmethod
    def _create_user_in_db(cls, uid, locale, **kwargs):
        if not usrctl.check(uid):
            log.debug('creating repository for %s, locale NA, type %s' % (uid, cls.type))
            usrctl.create(uid, cls.type, locale)
    
    @classmethod
    def NeedInit(cls, uid, project, *args, **kwargs):
        return super(AttachUser, cls).NeedInit(uid, project, db=True, data=True, sid=False)
