# -*- coding: utf-8 -*-
"""

MPFS
CORE

Фабрика пользователей

"""
import mpfs.engine.process

from mpfs.common.util import logger
from mpfs.common import errors
from mpfs.core.user.anonymous import AnonymousUID, AnonymousUser
from mpfs.core.user.common import CommonUser
from mpfs.core.user.standart import StandartUser
from mpfs.core.user.attach import AttachUser
from mpfs.core.user.yashell import YaShellSettingsUser
from mpfs.core.user.narod import NarodUser
from mpfs.engine.process import share_user
from mpfs.core.user import constants

log = mpfs.engine.process.get_default_log()
error_log = mpfs.engine.process.get_error_log()

usrctl = mpfs.engine.process.usrctl()
dbctl = mpfs.engine.process.dbctl()

def User(uid, project='disk'):
    # Сначала проверяем не аноним ли юзер (чтобы не искать его в базе)
    if AnonymousUID.is_anonymous_uid(uid):
        return AnonymousUser(uid)
    user_index_info = usrctl.check(uid)
    if user_index_info:
        if uid == share_user():
            return StandartUser(uid, project=project, info=user_index_info)
        else:
            type = user_index_info.get('type')
            for cls in CommonUser.__subclasses__():
                if cls.is_for(type):
                    return cls(uid, project=project, info=user_index_info)

    raise errors.StorageInitUser(uid)

def Create(uid, project='disk', type='standart', **params):
    for cls in CommonUser.__subclasses__():
        if cls.is_for(type):
            return cls.Create(uid, project=project, **params)

def NeedInit(uid, project='disk', type='standart', **params):
    for cls in CommonUser.__subclasses__():
        if cls.is_for(type):
            return cls.NeedInit(uid, project=project, **params)

def Check(uid, project='disk', type='standart'):
    for cls in CommonUser.__subclasses__():
        if cls.is_for(type):
            return cls.Check(uid, project=project)
