# -*- coding: utf-8 -*-
import sys
import click


@click.command('back_to_school', help=u"Обработать заявки на получение места по акции Диск для ВУЗов за указанные даты")
def back_to_school():
    """Обработка заявок

    Надо скачать заявки с YT за нужный день и скормить этому скрипту
    > YT_PROXY=hahn yt read "//home/assessor-research/bob1708/test/yadisk/back_to_school/2017-08-21" --format json
    Формат вывода: "<status>\t<application>"
    Ошибки смотреть в error логе
    """
    import mpfs.engine.process
    mpfs.engine.process.setup_admin_script()

    from mpfs.common.util import from_json
    from mpfs.core.user.back_to_school import process_application

    for json_application in sys.stdin:
        json_application = json_application.strip()
        dict_application = from_json(json_application)
        status = process_application(dict_application)
        click.echo("%s\t%s" % (status, json_application))
