# -*- coding: utf-8 -*-
import click


@click.command('force_snapshot', help=u"Зафорсить все инсталяции пользователя получить снепшот.")
@click.argument('uid')
def force_snapshot(uid):
    """Заставить пользователя получить снепшот.

    После запуска скрипта, все инсталляции пользователя при следюущей попытке синхронизироваться через дельты клиент
    получит полный снепшот. Так произойдет со всеми инсталяциями пользователя. Делается через модицифкацию поля
    force_snapshot_version в таблице disk.users спеыиальным образом.
    """
    import mpfs.engine.process
    mpfs.engine.process.setup_admin_script()

    from mpfs.core.user.dao.user import UserDAO

    UserDAO().force_user_to_get_snapshot(uid)
